function Q = optimization(X)

cd('D:\Program Files\MATLAB\R2010b\COMSOL43\mli')
comsolPort=[2036 2037 2038];
t = getCurrentTask();
labit=t.ID;
mphstart(comsolPort(labit));

import com.comsol.model.*
import com.comsol.model.util.*
model = ModelUtil.create('Model');

% model.modelPath('C:\Users\Administrator\Desktop');
% 
% model.name('FCM_transient.mph');

model.param.set('mug', '2.1e-5[Pa*s]');
model.param.set('kF', '1e-10[m^2]');
model.param.set('k', '1e-18');

model.modelNode.create('mod1');

model.geom.create('geom1', 2);
model.geom('geom1').feature.create('r1', 'Rectangle');
model.geom('geom1').feature('r1').set('size', {'500' '250'});

model.geom('geom1').feature.create('b1', 'BezierPolygon');
model.geom('geom1').feature.create('b2', 'BezierPolygon');
model.geom('geom1').feature.create('b3', 'BezierPolygon');
model.geom('geom1').feature('b1').set('p', {num2str(X(1)) num2str(X(1)); '0' '150'});
model.geom('geom1').feature('b1').set('degree', {'1'});
model.geom('geom1').feature('b1').set('w', {'1' '1'});
model.geom('geom1').feature('b2').set('p', {num2str(X(2)) num2str(X(2)); '0' '150'});
model.geom('geom1').feature('b2').set('degree', {'1'});
model.geom('geom1').feature('b2').set('w', {'1' '1'});
% model.geom('geom1').feature('b2').feature.comments('');
model.geom('geom1').feature('b3').set('p', {num2str(X(3)) num2str(X(3)); '0' '150'});
model.geom('geom1').feature('b3').set('degree', {'1'});
model.geom('geom1').feature('b3').set('w', {'1' '1'});
% model.geom('geom1').feature('b3').feature.comments('');

% load DFNdata.txt
% aa=DFNdata;
% for i=1:length(aa);    
% cl_name = ['c', num2str(i)];
% model.geom('geom1').feature.create(cl_name, 'BezierPolygon');
% model.geom('geom1').feature(cl_name).set('p', {num2str(aa(i,1)) num2str(aa(i,3)); num2str(aa(i,2)) num2str(aa(i,4))});
% model.geom('geom1').feature(cl_name).set('degree', {'1'});
% model.geom('geom1').feature(cl_name).set('w', {'1' '1'});
% 
% end


model.geom('geom1').run;

model.view.create('view2', 3);
model.view.create('view3', 2);
model.view.create('view4', 3);
model.view.create('view5', 2);
model.view.create('view6', 3);
model.view.create('view7', 2);
model.view.create('view8', 3);
model.view.create('view9', 2);
model.view.create('view10', 3);
model.view.create('view11', 2);
model.view.create('view12', 3);
model.view.create('view13', 2);
model.view.create('view14', 3);
model.view.create('view15', 2);
model.view.create('view16', 3);
model.view.create('view17', 2);
model.view.create('view18', 3);
model.view.create('view19', 2);
model.view.create('view20', 3);
model.view.create('view21', 2);
model.view.create('view22', 2);

model.physics.create('c', 'CoefficientFormPDE', 'geom1');
model.physics('c').field('dimensionless').field('p');
model.physics('c').field('dimensionless').component({'p'});
model.physics('c').feature.create('weak1', 'WeakContribution', 1);
model.physics('c').feature('weak1').selection.set([4 6 8]);
model.physics('c').feature.create('weak2', 'WeakContribution', 0);
model.physics('c').feature('weak2').selection.set([3 5 7]);

model.mesh.create('mesh1', 'geom1');
model.mesh('mesh1').feature.create('ftri1', 'FreeTri');
model.mesh('mesh1').feature('ftri1').feature.create('size1', 'Size');

model.view('view1').axis.set('xmin', '-25');
model.view('view1').axis.set('xmax', '525');
model.view('view1').axis.set('ymin', '-150.53921508789062');
model.view('view1').axis.set('ymax', '400.5392150878906');
model.view('view3').axis.set('xmin', '0.13068175315856934');
model.view('view3').axis.set('xmax', '10.869318008422852');
model.view('view3').axis.set('ymin', '0.5499999523162842');
model.view('view3').axis.set('ymax', '10.449999809265137');
model.view('view5').axis.set('xmin', '-89.31817626953125');
model.view('view5').axis.set('xmax', '689.3181762695312');
model.view('view5').axis.set('ymin', '-30');
model.view('view5').axis.set('ymax', '630');
model.view('view7').axis.set('xmin', '-89.31817626953125');
model.view('view7').axis.set('xmax', '689.3181762695312');
model.view('view7').axis.set('ymin', '-30');
model.view('view7').axis.set('ymax', '630');
model.view('view9').axis.set('xmin', '-89.31817626953125');
model.view('view9').axis.set('xmax', '689.3181762695312');
model.view('view9').axis.set('ymin', '-30');
model.view('view9').axis.set('ymax', '630');
model.view('view11').axis.set('xmin', '-89.31817626953125');
model.view('view11').axis.set('xmax', '689.3181762695312');
model.view('view11').axis.set('ymin', '-30');
model.view('view11').axis.set('ymax', '630');
model.view('view13').axis.set('xmin', '-14.886360168457031');
model.view('view13').axis.set('xmax', '114.88636016845703');
model.view('view13').axis.set('ymin', '-5');
model.view('view13').axis.set('ymax', '105');
model.view('view15').axis.set('xmin', '-36.57200241088867');
model.view('view15').axis.set('xmax', '138.80323791503906');
model.view('view15').axis.set('ymin', '-1.2068965435028076');
model.view('view15').axis.set('ymax', '108.79310607910156');
model.view('view17').axis.set('xmin', '-14.886360168457031');
model.view('view17').axis.set('xmax', '114.88636016845703');
model.view('view17').axis.set('ymin', '-5');
model.view('view17').axis.set('ymax', '105');
model.view('view19').axis.set('xmin', '-10.73385238647461');
model.view('view19').axis.set('xmax', '60.73385238647461');
model.view('view19').axis.set('ymin', '-2.5');
model.view('view19').axis.set('ymax', '52.5');
model.view('view21').axis.set('xmin', '-4.760274887084961');
model.view('view21').axis.set('xmax', '54.760276794433594');
model.view('view21').axis.set('ymin', '-2.5');
model.view('view21').axis.set('ymax', '52.5');
model.view('view22').axis.set('xmin', '-9.947090148925781');
model.view('view22').axis.set('xmax', '109.94709014892578');
model.view('view22').axis.set('ymin', '-5');
model.view('view22').axis.set('ymax', '105');

model.physics('c').prop('Units').set('DependentVariableQuantity', 'elasticity');
model.physics('c').prop('Units').set('CustomSourceTermUnit', 'Pa/s');
model.physics('c').feature('cfeq1').set('c', {'k*p/mug' '0' '0' 'k*p/mug'});
model.physics('c').feature('cfeq1').set('f', '0');
model.physics('c').feature('init1').set('p', '20e6');
model.physics('c').feature('weak1').set('weakExpression', '-pt*test(pt)-(kF/mug)*p*(test(pTx)*pTx+test(pTy)*pTy)');
model.physics('c').feature('weak2').set('weakExpression', 'test(p)*3e6-test(p)*p');

model.mesh('mesh1').feature('ftri1').feature('size1').set('hauto', 2);
model.mesh('mesh1').run;

model.study.create('std1');
model.study('std1').feature.create('time', 'Transient');
ModelUtil.showProgress(true);

model.sol.create('sol1');
model.sol('sol1').study('std1');
model.sol('sol1').attach('std1');
model.sol('sol1').feature.create('st1', 'StudyStep');
model.sol('sol1').feature.create('v1', 'Variables');
model.sol('sol1').feature.create('t1', 'Time');
model.sol('sol1').feature('t1').feature.create('fc1', 'FullyCoupled');
model.sol('sol1').feature('t1').feature.remove('fcDef');

model.result.dataset.create('cln1', 'CutLine2D');
model.result.dataset.create('cln2', 'CutLine2D');
model.result.dataset.create('cln3', 'CutLine2D');
model.result.dataset.create('cln4', 'CutLine2D');
model.result.dataset.create('cln5', 'CutLine2D');
model.result.dataset.create('cln6', 'CutLine2D');
model.result.numerical.create('int1', 'IntLine');
model.result.numerical('int1').set('probetag', 'none');

% model.result.dataset.create('cln1', 'CutLine2D');
% model.result.numerical.create('int1', 'IntLine');
% model.result.numerical('int1').selection.set([4 6 8]);

model.study('std1').feature('time').set('tlist', '10^{range(0,8/299,8)}');

model.sol('sol1').attach('std1');
model.sol('sol1').feature('st1').name('Compile Equations: Time Dependent');
model.sol('sol1').feature('st1').set('studystep', 'time');
model.sol('sol1').feature('v1').set('control', 'time');
model.sol('sol1').feature('t1').set('control', 'time');
model.sol('sol1').feature('t1').set('tlist', '10^{range(0,8/299,8)}');
model.sol('sol1').runAll;

model.result.dataset('cln1').set('genpoints', {num2str(X(1)-0.01) num2str(0); num2str(X(1)-0.01) num2str(150)});
model.result.dataset('cln2').set('spacevars', {'cln1x'});
model.result.dataset('cln2').set('genpoints', {num2str(X(1)+0.01) num2str(0); num2str(X(1)+0.01) num2str(150)}); 
model.result.dataset('cln2').set('spacevars', {'cln1x'});
model.result.dataset('cln3').set('genpoints', {num2str(X(2)-0.01) num2str(0); num2str(X(2)-0.01) num2str(150)});
model.result.dataset('cln3').set('spacevars', {'cln1x'});
model.result.dataset('cln4').set('genpoints', {num2str(X(2)+0.01) num2str(0); num2str(X(2)+0.01) num2str(150)}); 
model.result.dataset('cln4').set('spacevars', {'cln1x'});
model.result.dataset('cln5').set('genpoints', {num2str(X(3)-0.01) num2str(0); num2str(X(3)-0.01) num2str(150)});
model.result.dataset('cln5').set('spacevars', {'cln1x'});
model.result.dataset('cln6').set('genpoints', {num2str(X(3)+0.01) num2str(0); num2str(X(3)+0.01) num2str(150)}); 
model.result.dataset('cln6').set('spacevars', {'cln1x'});


model.result.numerical('int1').set('data', 'cln1');
model.result.numerical('int1').set('expr', 'k*px/mug*4000');
model.result.numerical('int1').set('unit', '');
model.result.numerical('int1').set('descr', 'k*px/mug*4000');
model.result.table.create('tbl1', 'Table');
model.result.table('tbl1').comments('Line Integration 1 (k*px/mug*86400*4000)');
model.result.numerical('int1').set('table', 'tbl1');
model.result.numerical('int1').setResult;
model.result.numerical('int1').set('data', 'cln2');
model.result.numerical('int1').set('table', 'tbl1');
model.result.numerical('int1').appendResult;
model.result.numerical('int1').set('data', 'cln3');
model.result.numerical('int1').set('table', 'tbl1');
model.result.numerical('int1').appendResult;
model.result.numerical('int1').set('data', 'cln4');
model.result.numerical('int1').set('table', 'tbl1');
model.result.numerical('int1').appendResult;
model.result.numerical('int1').set('data', 'cln5');
model.result.numerical('int1').set('table', 'tbl1');
model.result.numerical('int1').appendResult;
model.result.numerical('int1').set('data', 'cln6');
model.result.numerical('int1').set('table', 'tbl1');
model.result.numerical('int1').appendResult;

model.result.table('tbl1').save('aa.txt');

% Q1=10.^colon(0,8/299,8);
% Q11=Q1';
% Q2=mphint(model,'86400*k*px/mug','edim',1,'selection',[4 6 8]);
% Q21=Q2';
% Q3=[Q11,Q21];
% Q=trapz(Q3(:,1),Q3(:,2));
% modelName = fullfile('C:\Users\Administrator\Desktop','1.mph');
% mphsave(model,modelName);
load aa.txt;
Q1=aa;
for i=1:length(Q1)
    Q1(i,8)=-Q1(i,2)+Q1(i,3)-Q1(i,4)+Q1(i,5)-Q1(i,6)+Q1(i,7);
end
Q=-(trapz(Q1(:,1),Q1(:,8)));
end

% model.result.dataset('cln1').set('genpoints', {'0' '50'; '100' '50'});
% model.result.numerical('int1').set('expr', 'k*px/mug');
% model.result.numerical('int1').set('unit', '1/s');
% model.result.numerical('int1').set('descr', 'k*px/mug');
% model.result('pg1').set('view', 'view1');
% model.result('pg1').set('showhiddenobjects', true);


